/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.logging.targets;

import de.willuhn.io.FileCopy;
import de.willuhn.logging.Logger;
import de.willuhn.logging.Message;
import de.willuhn.logging.targets.Target;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class LogrotateTarget
implements Target {
    private File file = null;
    private OutputStream os = null;
    private boolean append = true;
    private boolean skipRotate = false;
    private long maxLength = 0x100000L;
    private boolean zip = true;
    private static final DateFormat DF = new SimpleDateFormat("yyyyMMdd-HHmm_ss");
    private static final String lineSep = System.getProperty("line.separator");

    public LogrotateTarget(File target, boolean append) throws IOException {
        this.file = target;
        this.append = append;
        this.os = new FileOutputStream(this.file, this.append);
    }

    public void setMaxLength(long length) {
        this.maxLength = length;
    }

    public void setZip(boolean zip) {
        this.zip = zip;
    }

    @Override
    public void write(Message message) throws Exception {
        if (message == null) {
            return;
        }
        this.checkRotate();
        this.os.write((message.toString() + lineSep).getBytes());
    }

    @Override
    public void close() throws Exception {
        this.os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkRotate() throws IOException {
        if (this.skipRotate) {
            return;
        }
        OutputStream outputStream = this.os;
        synchronized (outputStream) {
            if (this.file.length() < this.maxLength) {
                return;
            }
            Logger.info("rotating log file " + this.file.getAbsolutePath());
            Logger.debug("closing old log file");
            this.os.close();
            String name = this.file.getName();
            if (this.zip) {
                File archiveFile = new File(this.file.getParent(), name + "-" + DF.format(new Date()) + ".gz");
                Logger.info("compressing old log file to " + archiveFile.getAbsolutePath());
                OutputStream os = null;
                InputStream is = null;
                try {
                    os = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(archiveFile)));
                    is = new BufferedInputStream(new FileInputStream(this.file));
                    byte[] buf = new byte[4096];
                    int read = 0;
                    do {
                        if ((read = is.read(buf)) <= 0) continue;
                        os.write(buf, 0, read);
                    } while (read != -1);
                    Logger.info("old log file compressed");
                }
                catch (Throwable t) {
                    Logger.error("error while rotating logfile, disable rotating", t);
                    this.skipRotate = true;
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e) {
                            Logger.error("error while closing outputstream, disable rotating");
                            this.skipRotate = true;
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            Logger.error("error while closing inputstream, disable rotating");
                            this.skipRotate = true;
                        }
                    }
                }
            } else {
                File archiveFile = new File(this.file.getParent(), name + "-" + DF.format(new Date()));
                Logger.info("copying log file to " + archiveFile.getAbsolutePath());
                try {
                    FileCopy.copy(this.file, archiveFile, true);
                }
                catch (FileCopy.FileExistsException e) {
                    Logger.error("unable to copy log file, disable rotating", e);
                    this.skipRotate = true;
                }
            }
            Logger.info("deleting old log file");
            if (this.file.delete()) {
                Logger.info("creating new log file " + name);
                this.file = new File(this.file.getParent(), name);
            } else {
                Logger.error("unable to delete old log file " + name + ", disable rotating");
                this.skipRotate = true;
            }
            this.os = new FileOutputStream(this.file, this.append);
            Logger.info("logrotation done");
        }
    }
}

